﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/core/news_NewlyArrivedEventListener.h>
#include <mutex>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

NewlyArrivedEventListener::NewlyArrivedEventListener() NN_NOEXCEPT :
    m_Mutex(true)
{
    std::memset(m_IsRegistered, 0, sizeof (m_IsRegistered));
}

NewlyArrivedEventListener::~NewlyArrivedEventListener() NN_NOEXCEPT
{
    for (int i = 0; i < EventCountMax; i++)
    {
        if (m_IsRegistered[i])
        {
            nn::os::DestroySystemEvent(&m_Events[i]);
        }
    }
}

void NewlyArrivedEventListener::RegisterEvent(nn::os::NativeHandle eventHandle) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < EventCountMax; i++)
    {
        if (!m_IsRegistered[i])
        {
            nn::os::AttachWritableHandleToSystemEvent(&m_Events[i], eventHandle, false, nn::os::EventClearMode_ManualClear);
            m_IsRegistered[i] = true;
            break;
        }
    }
}

void NewlyArrivedEventListener::UnregisterEvent(nn::os::NativeHandle eventHandle) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < EventCountMax; i++)
    {
        if (m_IsRegistered[i] && nn::os::GetWritableHandleOfSystemEvent(&m_Events[i]) == eventHandle)
        {
            nn::os::DestroySystemEvent(&m_Events[i]);
            m_IsRegistered[i] = false;
            break;
        }
    }
}

void NewlyArrivedEventListener::SignalAll() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < EventCountMax; i++)
    {
        if (m_IsRegistered[i])
        {
            nn::os::SignalSystemEvent(&m_Events[i]);
        }
    }
}

}}}}}
