﻿using std;
using nn;
using nn.sf;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.lm
{
    [CppRefPath(@"<nn/lm/detail/lm_ILogService.h>")]
    interface ILogService : IServiceObject
    {
        [MethodId(0)]
        Result
            OpenLogger(
                Out<ILogger> pOut,
                [ProcessId] Bit64 processId
            );
    }

    [CppRefPath(@"<nn/lm/detail/lm_ILogService.h>")]
    interface ILogger : IServiceObject
    {
        [MethodId(0)]
        Result
            Log(
                [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] InBuffer message
            );

        [MethodId(1)]
        Result SetDestination(Bit32 destination);
    }
}
