﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "lm_LoggerImpl.h"

namespace nn { namespace lm { namespace impl {

LoggerImpl::LoggerImpl(LogServiceImpl* parent, Bit64 processId) NN_NOEXCEPT
    : m_Parent(parent, true)
    , m_ProcessId(processId)
{
}

LoggerImpl::~LoggerImpl() NN_NOEXCEPT
{
}

Result LoggerImpl::Log(sf::InBuffer message) NN_NOEXCEPT
{
    NN_UNUSED(message);

    return ResultSuccess();
}

Result LoggerImpl::SetDestination(Bit32 destination) NN_NOEXCEPT
{
    NN_UNUSED(destination);
    return ResultSuccess();
}

}}} // nn::lm::impl
