﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include "lm_LogServiceImpl.h"
#include "lm_LoggerImpl.h"

namespace nn { namespace lm { namespace impl {

namespace {
    struct LoggerImplAllocatorTag;
    typedef nn::sf::ExpHeapStaticAllocator<16 * 1024, LoggerImplAllocatorTag> LoggerImplAllocator;

    class LoggerImplAllocatorInitializer
    {
    public:
        LoggerImplAllocatorInitializer() NN_NOEXCEPT
        {
            LoggerImplAllocator::Initialize(lmem::CreationOption_NoOption);
        }
    };
}

Result LogServiceImpl::OpenLogger(
    sf::Out<sf::SharedPointer<lm::ILogger>> pOut,
    Bit64 processId) NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(LoggerImplAllocatorInitializer, s_LoggerImplAllocatorInitializer);
    NN_UNUSED(s_LoggerImplAllocatorInitializer);

    auto p = sf::ObjectFactory<LoggerImplAllocator::Policy>::CreateSharedEmplaced<ILogger, LoggerImpl>(this, processId);
    pOut.Set(std::move(p));
    return ResultSuccess();
}

}}} // nn::lm::impl
