﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include "lbl_BacklightLowDriverStub.h"
#include <nn/nn_Macro.h>

namespace nn {
namespace gpio {

namespace
{
Direction g_Direction;      // 入力 or 出力
GpioValue g_InputValue;     // 設定した入力側の値
GpioValue g_OutputValue;    // 設定した出力側の値
}

void Initialize() NN_NOEXCEPT
{
    g_Direction = static_cast<Direction>(-1);
    g_InputValue = static_cast<GpioValue>(-1);
    g_OutputValue = static_cast<GpioValue>(-1);
}

void Finalize() NN_NOEXCEPT
{
}

void OpenSession(GpioPadSession* pOutSession, GpioPadName pad) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(pad);
}

void CloseSession(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void SetDirection(GpioPadSession* pSession, Direction direction) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    g_Direction = direction;
}

void SetValue(GpioPadSession* pSession, GpioValue value) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    // 直前に設定した direction に応じた値を保存(テスト目的で)。
    if (nn::gpio::Direction_Input == g_Direction)
    {
        g_InputValue = value;
    }
    else if (nn::gpio::Direction_Output == g_Direction)
    {
        g_OutputValue = value;
    }
    NN_UNUSED(value);
}

GpioValue GetValue(GpioPadSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    if (nn::gpio::Direction_Input == g_Direction)
    {
        return g_InputValue;
    }
    else if (nn::gpio::Direction_Output == g_Direction)
    {
        return g_OutputValue;
    }
    return static_cast<GpioValue>(-1);
}

} // gpio
} // nn

namespace nn {
namespace pwm {

namespace
{
int g_Duty;     // 設定した duty 比
}

void Initialize() NN_NOEXCEPT
{
    g_Duty = 0;
}

void Finalize() NN_NOEXCEPT
{
}

void OpenSession(ChannelSession* pOutSession, ChannelName name) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(name);
}

void CloseSession(ChannelSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
}

void SetPeriod(ChannelSession* pSession, nn::TimeSpan period) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(period);
}

void SetDuty(ChannelSession* pSession, int duty) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    g_Duty = duty;
}

int GetDuty(ChannelSession* pSession) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    return g_Duty;
}

void SetEnabled(ChannelSession* pSession, bool enable) NN_NOEXCEPT
{
    NN_UNUSED(pSession);
    NN_UNUSED(enable);
}

} // pwm
} // nn
