﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ライブラリアプレットの共通引数の受け渡しをおこなうクラスの実装
 */

#include <nn/la/la_NifmToWifiWebAuthArgumentsWriter.h>

#include <nn/applet/applet.h>

#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>

#include <nn/la/la_Configs.h>
#include <nn/la/la_Result.h>

#include <nn/util/util_StringUtil.h>


namespace nn { namespace la {

namespace {

static const uint32_t CurrentNifmToWifiWebAuthVersion = NN_DETAIL_LA_CURRENT_NIFMTOWIFIWEBAUTH_VERSION;

}

NifmToWifiWebAuthArgumentsWriter::NifmToWifiWebAuthArgumentsWriter(const char* pAuthUrl, const char* pConnTestUrl, const nn::util::Uuid& profileId, uint32_t submitId) NN_NOEXCEPT
{
    int len = nn::util::Strlcpy(m_NifmToWifiWebAuthArgumentsData.authUrl, pAuthUrl, sizeof(m_NifmToWifiWebAuthArgumentsData.authUrl));
    NN_SDK_ASSERT(len < sizeof(m_NifmToWifiWebAuthArgumentsData.authUrl) - 1);

    len = nn::util::Strlcpy(m_NifmToWifiWebAuthArgumentsData.connTestUrl, pConnTestUrl, sizeof(m_NifmToWifiWebAuthArgumentsData.connTestUrl));
    NN_SDK_ASSERT(len < sizeof(m_NifmToWifiWebAuthArgumentsData.connTestUrl) - 1);
    NN_UNUSED(len);

    m_NifmToWifiWebAuthArgumentsData.profileId = profileId;
    m_NifmToWifiWebAuthArgumentsData.submitId = submitId;
}

NifmToWifiWebAuthArgumentsWriter::~NifmToWifiWebAuthArgumentsWriter() NN_NOEXCEPT
{
}

void NifmToWifiWebAuthArgumentsWriter::PushToInChannel(nn::applet::LibraryAppletHandle libraryAppletHandle) const NN_NOEXCEPT
{
    nn::applet::StorageHandle storageHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::CreateStorage(&storageHandle, sizeof(CurrentNifmToWifiWebAuthVersion) + sizeof(m_NifmToWifiWebAuthArgumentsData)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, 0, &CurrentNifmToWifiWebAuthVersion, sizeof(CurrentNifmToWifiWebAuthVersion)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, sizeof(CurrentNifmToWifiWebAuthVersion), &m_NifmToWifiWebAuthArgumentsData, sizeof(m_NifmToWifiWebAuthArgumentsData)));
    nn::applet::PushToInChannel(libraryAppletHandle, storageHandle);
}

size_t NifmToWifiWebAuthArgumentsWriter::GetExportSize() const NN_NOEXCEPT
{
    return sizeof(CurrentNifmToWifiWebAuthVersion) + sizeof(m_NifmToWifiWebAuthArgumentsData);
}

void NifmToWifiWebAuthArgumentsWriter::Export(char buffer[], size_t size) const NN_NOEXCEPT
{
    NN_ABORT_UNLESS_GREATER_EQUAL(size, GetExportSize());

    std::memcpy(&buffer[0], &CurrentNifmToWifiWebAuthVersion, sizeof(CurrentNifmToWifiWebAuthVersion));
    std::memcpy(&buffer[sizeof(CurrentNifmToWifiWebAuthVersion)], &m_NifmToWifiWebAuthArgumentsData, sizeof(m_NifmToWifiWebAuthArgumentsData));
}

}} // namespace nn::la

