﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ライブラリアプレットからの応答の受け渡しをおこなうクラスの実装
 */

#include <nn/la/la_AppletToNifmArgumentsWriter.h>

#include <nn/ae/ae_LibraryAppletApi.h>
#include <nn/applet/applet.h>

#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>

#include <nn/la/la_Configs.h>
#include <nn/la/la_Result.h>

#include <nn/nifm/nifm_Result.h>
#include <nn/nifm/nifm_ResultPrivate.h>

#include <nn/util/util_StringUtil.h>


namespace nn { namespace la {

namespace {

static const uint32_t CurrentAppletToNifmVersion = NN_DETAIL_LA_CURRENT_APPLETTONIFM_VERSION;

}

AppletToNifmArgumentsWriter::AppletToNifmArgumentsWriter(bool isConnTestSuccess) NN_NOEXCEPT
{
    if (isConnTestSuccess)
    {
        m_AppletToNifmArgumentsData.result = nn::nifm::ResultErrorHandlingCompleted();
    }
    else
    {
        m_AppletToNifmArgumentsData.result = nn::nifm::ResultInternetLayerNotAvailable();
    }
}

AppletToNifmArgumentsWriter::~AppletToNifmArgumentsWriter() NN_NOEXCEPT
{
}

void AppletToNifmArgumentsWriter::PushToOutChannel() const NN_NOEXCEPT
{
    nn::ae::StorageHandle storageHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::CreateStorage(&storageHandle, sizeof(CurrentAppletToNifmVersion) + sizeof(m_AppletToNifmArgumentsData)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, 0, &CurrentAppletToNifmVersion, sizeof(CurrentAppletToNifmVersion)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, sizeof(CurrentAppletToNifmVersion), &m_AppletToNifmArgumentsData, sizeof(m_AppletToNifmArgumentsData)));
    nn::ae::PushToOutChannel(storageHandle);
}

}} // namespace nn::la

