﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.jit
{
    [CppRefPath("<nn/jit/jit_CommonTypes.h>")]
    [ExternalStruct(16, 8)]
    public struct CodeRange
    {
    }
}

namespace nn.jitsrv
{
    [CppRefPath(Location.JitServiceSfdlPath)]
    public interface IJitService : IServiceObject
    {
        [MethodId(0)]
        Result CreateJitEnvironment(Out<IJitEnvironment> pOut, NativeHandle processHandle, NativeHandle rxHandle, uint64_t rxSize, NativeHandle roHandle, uint64_t roSize);
    }

    public interface IJitEnvironmentBase : IServiceObject
    {
        [MethodId(1000)]
        Result LoadPlugin(InBuffer nrr, InBuffer nro, NativeHandle workMemory, uint64_t workMemorySize);

        [MethodId(1001)]
        Result GetCodeAddress(Out<uint64_t> pRxCodeAddress, Out<uint64_t> pRoCodeAddress);
    }

    [CppRefPath(Location.JitServiceSfdlPath)]
    public struct Struct32
    {
        public uint64_t m0;
        public uint64_t m1;
        public uint64_t m2;
        public uint64_t m3;
    }

    public interface IJitEnvironment : IJitEnvironmentBase
    {
        [MethodId(0)]
        Result GenerateCode(Out<int> pOut, Out<jit.CodeRange> pGeneratedRx, Out<jit.CodeRange> pGeneratedRo, InBuffer source, uint64_t tag, jit.CodeRange rxRange, jit.CodeRange roRange, Struct32 inData, uint32_t inDataSize, OutBuffer outBuffer);

        [MethodId(1)]
        Result Control(Out<int> pOut, uint64_t tag, InBuffer inData, OutBuffer outData);
    }
}
