﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/jit/plugin/jit_PluginUtility.h>
#include <nn/jit/plugin/jit_DllInterface.h>

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>

#include "jit_Globals.h"

namespace nn { namespace jit { namespace plugin {

namespace {

bool g_IsDevelopmentFunctionsEnabled = false;

}

void EnableDevelopmentFunctions() NN_NOEXCEPT
{
    if (g_pConfigureParameters)
    {
        g_IsDevelopmentFunctionsEnabled = true;
    }
    else
    {
        NN_SDK_LOG("[jit] nn::jit::plugin::EnableDevelopmentFunctions() is called but is denied.\n");
    }
}

void SetCodeMemorySecurityForDevelopment(MemorySecurityMode mode) NN_NOEXCEPT
{
    if (g_IsDevelopmentFunctionsEnabled)
    {
        g_pConfigureParameters->codeMemorySecurity = mode;
    }
    else
    {
        NN_SDK_LOG("[jit] nn::jit::plugin::SetCodeMemorySecurityForDevelopment() is called but no effects.\n");
    }
}

void SetWorkMemorySecurityForDevelopment(MemorySecurityMode mode) NN_NOEXCEPT
{
    if (g_IsDevelopmentFunctionsEnabled)
    {
        g_pConfigureParameters->workMemorySecurity = mode;
    }
    else
    {
        NN_SDK_LOG("[jit] nn::jit::plugin::SetWorkMemorySecurityForDevelopment() is called but it no effects.\n");
    }
}

}}}
