﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/idle/server/idle_HandlerManager.h>
#include <nn/idle/server/idle_PolicyManagerSystemImpl.h>

namespace nn { namespace idle { namespace server {

nn::Result PolicyManagerSystemImpl::GetAutoPowerDownEvent(nn::sf::Out<nn::sf::NativeHandle> pOutNativeHandle) NN_NOEXCEPT
{
    auto* pEvent = server::GetAutoPowerDownEvent();
    nn::os::NativeHandle internalHandle = nn::os::GetReadableHandleOfSystemEvent(pEvent);
    *pOutNativeHandle = nn::sf::NativeHandle(internalHandle, false);
    NN_RESULT_SUCCESS;
}

nn::Result PolicyManagerSystemImpl::SetHandlingContext(const nn::idle::HandlingContext& handlingContext) NN_NOEXCEPT
{
    NN_RESULT_DO(server::SetHandlingContext(handlingContext));
    NN_RESULT_SUCCESS;
}

nn::Result PolicyManagerSystemImpl::LoadAndApplySettings() NN_NOEXCEPT
{
    server::LoadAndApplySettings();
    NN_RESULT_SUCCESS;
}

nn::Result PolicyManagerSystemImpl::ReportUserIsActive() NN_NOEXCEPT
{
    server::ResetIdleTimeCount();
    NN_RESULT_SUCCESS;
}

}}} // namespace nn::idle::server
