﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h>   // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>        // for nn::sf::ExpHeapStaticAllocator

#include <nn/i2c/i2c_ServiceType.h>
#include <nn/i2c/i2c_ISession.sfdl.h>
#include <nn/i2c/i2c_IManager.sfdl.h>

namespace nn { namespace i2c {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateI2cManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateI2cManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<nn::i2c::IManager> GetManagerByHipc(const char* serviceName) NN_NOEXCEPT
{
    // I2cServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // II2cManager としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::i2c::IManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<nn::i2c::IManager, MyAllocator::Policy>(&ret, serviceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

}}
