﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_DeviceCode.h>

#include <nn/i2c/i2c_DeviceName.h>
#include <nn/TargetConfigs/build_Base.h>

#if (defined(NN_BUILD_CONFIG_SOC_TEGRA_X1))
#include "i2c_Gen1DeviceNameConvertTable-soc.tegra-x1.h"
#else
const nn::DeviceCode Gen1DeviceNameConvertTable[] = {};
const int Gen1DeviceNameConvertTableLength = 0;
#endif

namespace nn { namespace i2c { namespace driver {

bool FindCompatDeviceCodeEntryForGen1(nn::DeviceCode* pOutDeviceCode, I2cDevice i2cDevice) NN_NOEXCEPT
{
    if ( i2cDevice < 0 || Gen1DeviceNameConvertTableLength <= i2cDevice )
    {
        return false;
    }

    auto deviceCode = Gen1DeviceNameConvertTable[i2cDevice];

    // 現実装では通らない
    if ( deviceCode == nn::DeviceCode::GetInvalidCode() )
    {
        return false;
    }

    *pOutDeviceCode = deviceCode;

    return true;
}

}}} // nn::i2c::driver
