﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/i2c/driver/detail/dt/i2c_DeviceCodeNodeParser.h>
#include <nn/i2c/driver/i2c_II2cDriver.h>
#include <nn/i2c/driver/i2c_DriverServiceApi.h>

#include "detail/i2c_Core.h"

namespace nn { namespace i2c { namespace driver {

void RegisterDriver(II2cDriver* pDriver) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDriver);
    detail::RegisterDriver(pDriver);
}

void RegisterDeviceCodeNodeParser(nn::i2c::driver::detail::dt::IDeviceCodeNodeParser* pParser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pParser);
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::RegisterDeviceCodeNodeParser(pParser));
}

nn::Result RegisterDeviceCode(nn::DeviceCode deviceCode, I2cDeviceProperty* pDevice) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pDevice);
    return detail::RegisterDeviceCode(deviceCode, pDevice);
}

}}} // nn::i2c::driver
