﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/nn_Result.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/util/util_IntrusiveList.h>

#include "../htclow_Packet.h"

namespace nn { namespace htclow { namespace server { namespace mux {

class ReceiveBuffer final
{
    NN_DISALLOW_COPY(ReceiveBuffer);
    NN_DISALLOW_MOVE(ReceiveBuffer);

public:
    ReceiveBuffer() NN_NOEXCEPT;
    ~ReceiveBuffer() NN_NOEXCEPT;

    nn::os::SystemEvent* GetReceiveReadyEvent() NN_NOEXCEPT
    {
        return &m_ReceiveReadyEvent;
    }

    Result AddPacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;

    int GetReadableBodySize() NN_NOEXCEPT;

    Result ReadBody(void* pOutBuffer, int bufferSize) NN_NOEXCEPT;

private:
    static const int MaxChannelBufferSize = 8 * 1024 * 1024;

    // 受信データを読み出し可能になるとシグナルされるイベント
    nn::os::SystemEvent m_ReceiveReadyEvent;

    // 受信データを保持するパケットのリスト
    // 読み出されて不要になったパケットは破棄される
    nn::util::IntrusiveList<ReceivePacket, nn::util::IntrusiveListBaseNodeTraits<ReceivePacket>> m_Packets;

    // リストの先頭のパケットにおいて Read 済のバイト数
    int m_HeadOffset = 0;

    // 次に追加されるパケットに期待されるシーケンス番号
    int64_t m_NextSequenceId = 1L;
};

}}}}
