﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>

#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_ResultPrivate.h>

#include <nn/htcfs/htcfs_Result.h>
#include <nn/htcfs/htcfs_ResultPrivate.h>

#include "htcfs_ResultConversion.h"

namespace nn { namespace htcfs { namespace server {

nn::Result ConvertHtcfsResult(int64_t htcfsResult) NN_NOEXCEPT
{
    switch (static_cast<HtcfsResult>(htcfsResult))
    {
    case HtcfsResult::Success:
        return nn::ResultSuccess();
    case HtcfsResult::UnsupportedVersion:
        return nn::htcfs::ResultUnsupportedProtocolVersion();
    case HtcfsResult::InvalidRequest:
        return nn::htcfs::ResultInvalidRequest();
    case HtcfsResult::InvalidHandle:
        return nn::htcfs::ResultInvalidHandle();
    case HtcfsResult::OutOfHandle:
        return nn::htcfs::ResultOutOfHandle();
    default:
        return nn::htcfs::ResultUnknownError();
    }
}

nn::Result ConvertNativeResult(int64_t nativeResult) NN_NOEXCEPT
{
    auto innerValue = static_cast<nn::result::detail::ResultTraits::InnerType>(nativeResult);
    return nn::result::detail::ConstructResult(innerValue);
}

}}}
