﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include "htcfs_HeaderFactory.h"

namespace nn { namespace htcfs { namespace server {

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType) NN_NOEXCEPT
{
    MakeRequestHeader(pOutHeader, packetType, 0, 0, 0, 0, 0, 0);
}

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize) NN_NOEXCEPT
{
    MakeRequestHeader(pOutHeader, packetType, bodySize, 0, 0, 0, 0, 0);
}

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0) NN_NOEXCEPT
{
    MakeRequestHeader(pOutHeader, packetType, bodySize, param0, 0, 0, 0, 0);
}

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1) NN_NOEXCEPT
{
    MakeRequestHeader(pOutHeader, packetType, bodySize, param0, param1, 0, 0, 0);
}

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1, int64_t param2) NN_NOEXCEPT
{
    MakeRequestHeader(pOutHeader, packetType, bodySize, param0, param1, param2, 0, 0);
}

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1, int64_t param2, int64_t param3) NN_NOEXCEPT
{
    MakeRequestHeader(pOutHeader, packetType, bodySize, param0, param1, param2, param3, 0);
}

void HeaderFactory::MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1, int64_t param2, int64_t param3, int64_t param4) NN_NOEXCEPT
{
    pOutHeader->protocol = HtcfsProtocol;
    pOutHeader->version = m_Version;
    pOutHeader->packetCategory = PacketCategory::Request;
    pOutHeader->packetType = packetType;
    pOutHeader->bodySize = bodySize;
    pOutHeader->param0 = param0;
    pOutHeader->param1 = param1;
    pOutHeader->param2 = param2;
    pOutHeader->param3 = param3;
    pOutHeader->param4 = param4;
    pOutHeader->reserved = 0;
}

}}}
