﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/htcfs/detail/htcfs_IServiceObject.h>

namespace nn { namespace htcfs { namespace server {

class FileServiceObject
{
public:
    explicit FileServiceObject(int32_t handle) NN_NOEXCEPT;
    ~FileServiceObject() NN_NOEXCEPT;

    nn::Result GetPriorityForFile(nn::sf::Out<std::int32_t> outPriority) NN_NOEXCEPT;
    nn::Result SetPriorityForFile(std::int32_t priority) NN_NOEXCEPT;
    nn::Result ReadFile(nn::sf::Out<std::int64_t> outSize, const nn::sf::OutBuffer& outBuffer, std::int64_t offset, nn::fs::ReadOption option) NN_NOEXCEPT;
    nn::Result WriteFile(const nn::sf::InBuffer& buffer, std::int64_t offset, nn::fs::WriteOption option) NN_NOEXCEPT;
    nn::Result FlushFile() NN_NOEXCEPT;
    nn::Result GetFileSize(nn::sf::Out<std::int64_t> outSize) NN_NOEXCEPT;
    nn::Result SetFileSize(std::int64_t size) NN_NOEXCEPT;

private:
    int32_t m_Handle;
};

}}}
