﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/htcfs/detail/htcfs_IServiceObject.h>

namespace nn { namespace htcfs { namespace server {

class DirectoryServiceObject
{
public:
    explicit DirectoryServiceObject(int32_t handle) NN_NOEXCEPT;
    ~DirectoryServiceObject() NN_NOEXCEPT;

    nn::Result GetPriorityForDirectory(nn::sf::Out<std::int32_t> outPriority) NN_NOEXCEPT;
    nn::Result SetPriorityForDirectory(std::int32_t priority) NN_NOEXCEPT;
    nn::Result GetEntryCount(nn::sf::Out<std::int64_t> outCount) NN_NOEXCEPT;
    nn::Result ReadDirectory(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::fs::DirectoryEntry>& entries) NN_NOEXCEPT;

private:
    int32_t m_Handle;
};

}}}
