﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.hdcp
{
    namespace detail
    {
        // 実操作を担当する HDCP のセッションオブジェクト。
        [CppRefPath("\"hdcp_IHdcpController.h\"")]
        public interface IHdcpController : IServiceObject
        {
            [MethodId(0)]
            Result GetHdcpStateTransitionEvent(Out<NativeHandle> outEventHandle);

            [MethodId(1)]
            Result GetHdcpAuthenticationState(Out<int32_t> outState);

            [MethodId(2)]
            Result SetCurrentHdcpMode(int32_t mode);

            [MethodId(3)]
            int32_t GetCurrentHdcpMode();

        }
    }
}
