﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nn_Common.h>
#include <hos/nvhdcp_up.h>

#include "hdcp_NvHdcpBase.h"

namespace nn { namespace hdcp { namespace impl { namespace detail {

class NvHdcpStub : public NvHdcpBase
{
    NN_DISALLOW_COPY(NvHdcpStub);
private:
    static NvHdcpStub m_Instance;
    NvHdcpStub() NN_NOEXCEPT;
    ~NvHdcpStub() NN_NOEXCEPT;

public:
    static NvHdcpStub& GetInstance() NN_NOEXCEPT;
    HDCP_RET_ERROR Open() NN_NOEXCEPT;
    HDCP_RET_ERROR Close() NN_NOEXCEPT;
    HDCP_RET_ERROR GetStatus() NN_NOEXCEPT;
    HDCP_RET_ERROR Enable(bool isEnabled) NN_NOEXCEPT;
    HDCP_RET_ERROR SetTransitHandler(nvhdcp_state_transit_handler handler, void* context) NN_NOEXCEPT;
    HDCP_RET_ERROR InitializeAsyncEvent() NN_NOEXCEPT;
    void SetPseudoError(HDCP_RET_ERROR error) NN_NOEXCEPT;
    void SignalPseudoEvent(nvhdcp_state state, void* context) NN_NOEXCEPT;
};

}}}} // namespace nn::hdcp::impl::detail
