﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_StaticAssert.h>

#include <nn/nn_DeviceCode.h>
#include <nnc/nn_DeviceCode.h>

#include <nn/gpio/gpio_Lib.h>
#include <nn/gpio/gpio_PadMap.h>
#include <nn/gpio/gpio_PadAccessor.h>
#include <nn/gpio/gpio_PadAccessorDev.h>
#include <nn/gpio/gpio_Type.h>

#include <nnc/gpio/gpio_Lib.h>
#include <nnc/gpio/gpio_PadMap.h>
#include <nnc/gpio/gpio_PadAccessor.h>
#include <nnc/gpio/gpio_PadAccessorDev.h>
#include <nnc/gpio/gpio_Type.h>

#include <nnc/nn_Result.h>
#include <nnc/result/result_CConverter.h>


//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメント、定数値等が一致しているのかをチェック
//---------------------------------------------------------------------------
static_assert(sizeof(nngpioInterruptMode) == sizeof(nn::gpio::InterruptMode), "");
static_assert(static_cast<int>(nngpioInterruptMode_LowLevel) == static_cast<int>(nn::gpio::InterruptMode_LowLevel), "");
static_assert(static_cast<int>(nngpioInterruptMode_HighLevel) == static_cast<int>(nn::gpio::InterruptMode_HighLevel), "");
static_assert(static_cast<int>(nngpioInterruptMode_RisingEdge) == static_cast<int>(nn::gpio::InterruptMode_RisingEdge), "");
static_assert(static_cast<int>(nngpioInterruptMode_FallingEdge) == static_cast<int>(nn::gpio::InterruptMode_FallingEdge), "");
static_assert(static_cast<int>(nngpioInterruptMode_AnyEdge) == static_cast<int>(nn::gpio::InterruptMode_AnyEdge), "");

static_assert(sizeof(nngpioDirection) == sizeof(nn::gpio::Direction), "");
static_assert(static_cast<int>(nngpioDirection_Input) == static_cast<int>(nn::gpio::Direction_Input), "");
static_assert(static_cast<int>(nngpioDirection_Output) == static_cast<int>(nn::gpio:: Direction_Output), "");

static_assert(sizeof(nngpioGpioValue) == sizeof(nn::gpio::GpioValue), "");
static_assert(static_cast<int>(nngpioGpioValue_Low) == static_cast<int>(nn::gpio::GpioValue_Low), "");
static_assert(static_cast<int>(nngpioGpioValue_High) == static_cast<int>(nn::gpio::GpioValue_High), "");

static_assert(sizeof(nngpioInterruptStatus) == sizeof(nn::gpio::InterruptStatus), "");
static_assert(static_cast<int>(nngpioInterruptStatus_Inactive) == static_cast<int>(nn::gpio::InterruptStatus_Inactive), "");
static_assert(static_cast<int>(nngpioInterruptStatus_Active) == static_cast<int>(nn::gpio::InterruptStatus_Active), "");


static_assert(sizeof(nngpioGpioPadSession) == sizeof(nn::gpio::GpioPadSession), "");
static_assert(NN_ALIGNOF(nngpioGpioPadSession) == NN_ALIGNOF(nn::gpio::GpioPadSession), "");
static_assert(offsetof(nngpioGpioPadSession, _sessionHandle) == offsetof(nn::gpio::GpioPadSession, _sessionHandle), "");
static_assert(offsetof(nngpioGpioPadSession, _pEvent) == offsetof(nn::gpio::GpioPadSession, _pEvent), "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

#ifdef __cplusplus
extern "C"
{
#endif // ifdef __cplusplus

void nngpioInitialize()
{
    nn::gpio::Initialize();
}

void nngpioFinalize()
{
    nn::gpio::Finalize();
}

// [Gen2] XXX: C はオーバーロードできないので API 名は仮
nnResult nngpioOpenSession2(nngpioGpioPadSession* pOutSession, nnDeviceCode pad)
{
    nn::Result result = nn::gpio::OpenSession(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pOutSession),
        static_cast<nn::DeviceCode>(nn::DeviceCode(pad._value))
        );

    return nn::result::ConvertToC(result);
}

// [Gen1] TODO: Deprecate
void nngpioOpenSession(nngpioGpioPadSession* pOutSession, nngpioGpioPadName pad)
{
    nn::gpio::OpenSession(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pOutSession),
        static_cast<nn::gpio::GpioPadName>(pad)
        );
}

// [Gen1] TODO: Deprecate
void nngpioOpenSessionForDev(nngpioGpioPadSession* pOutSession, int padNumber)
{
    nn::gpio::OpenSessionForDev(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pOutSession),
        padNumber
        );
}

void nngpioCloseSession(nngpioGpioPadSession* pSession)
{
    nn::gpio::CloseSession(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession)
        );
}

void nngpioSetDirection(nngpioGpioPadSession* pSession, nngpioDirection direction)
{
    nn::gpio::SetDirection(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession),
        static_cast<nn::gpio::Direction>(direction)
        );
}

nngpioDirection nngpioGetDirection(nngpioGpioPadSession* pSession )
{
    return static_cast<nngpioDirection>(nn::gpio::GetDirection(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession))
        );
}

void nngpioSetInterruptMode(nngpioGpioPadSession* pSession, nngpioInterruptMode mode )
{
    nn::gpio::SetInterruptMode(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession),
        static_cast<nn::gpio::InterruptMode>(mode)
        );
}

nngpioInterruptMode nngpioGetInterruptMode(nngpioGpioPadSession* pSession)
{
    return static_cast<nngpioInterruptMode>((nn::gpio::GetInterruptMode(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession)))
        );
}

void nngpioSetInterruptEnable(nngpioGpioPadSession* pSession, bool enable )
{
    nn::gpio::SetInterruptEnable(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession),
        enable
        );
}

bool nngpioGetInterruptEnable(nngpioGpioPadSession* pSession)
{
    return nn::gpio::GetInterruptEnable(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession)
        );
}

nngpioInterruptStatus nngpioGetInterruptStatus(nngpioGpioPadSession* pSession)
{
    return static_cast<nngpioInterruptStatus>(nn::gpio::GetInterruptStatus(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession))
        );
}

void nngpioClearInterruptStatus(nngpioGpioPadSession* pSession)
{
    nn::gpio::ClearInterruptStatus(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession)
        );
}

nngpioGpioValue nngpioGetValue(nngpioGpioPadSession* pSession)
{
    return static_cast<nngpioGpioValue>(nn::gpio::GetValue(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession))
        );
}

void nngpioSetValue(nngpioGpioPadSession* pSession, nngpioGpioValue value )
{
    nn::gpio::SetValue(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession),
        static_cast<nn::gpio::GpioValue>(value)
        );
}


nnResult nngpioBindInterrupt(nnosSystemEventType* pEvent, nngpioGpioPadSession* pSession)
{
    nn::Result result = nn::gpio::BindInterrupt(
        reinterpret_cast<nn::os::SystemEventType*>(pEvent),
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession)
        );

    return nn::result::ConvertToC(result);
}

void nngpioUnbindInterrupt(nngpioGpioPadSession* pSession)
{
    nn::gpio::UnbindInterrupt(
        reinterpret_cast<nn::gpio::GpioPadSession*>(pSession)
        );
}

#ifdef __cplusplus
}
#endif // ifdef __cplusplus
