﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   GPIO ドライバライブラリで使用する PadMap を切り替えます。
 */

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_DeviceCode.h>
#include <nn/gpio/gpio_PadMap.h>

#if (defined(NN_BUILD_CONFIG_SOC_TEGRA_X1))
    #define NN_DETAIL_GPIO_DRIVER_ENABLE_GEN1_PAD_NAME_CONVERT_TABLE
    #include "gpio_Gen1PadNameConvertTable-soc.tegra-x1.h"
#endif

namespace nn { namespace gpio { namespace driver {

    bool FindCompatDeviceCodeEntryForGen1(nn::DeviceCode* pOutDeviceCode, nn::gpio::GpioPadName gen1PadName) NN_NOEXCEPT
    {
#if defined(NN_DETAIL_GPIO_DRIVER_ENABLE_GEN1_PAD_NAME_CONVERT_TABLE)
        if ( gen1PadName < 0 || Gen1PadNameConvertTableLength <= gen1PadName )
        {
            return false;
        }
        auto deviceCode = Gen1PadNameConvertTable[gen1PadName];
        if (deviceCode == nn::DeviceCode::GetInvalidCode())
        {
            return false;
        }
        *pOutDeviceCode = deviceCode;
        return true;
#else
        NN_UNUSED(pOutDeviceCode);
        NN_UNUSED(gen1PadName);
        return false;
#endif
    }

}}} // nn::gpio::driver
