﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace gpio {
namespace driver {
namespace detail {


static struct GpioInitialConfig initGpioConfigListForCopper[] =
{
    {
        nn::gpio::GpioPadName_5VStepDownEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_GameCardReset,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchB2Oc,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_5VStepDownPg,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchAEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowSdEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PowGc,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchAFlag,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchB3Oc,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_GameCardCd,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchB3En,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchB2En,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType0,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType1,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ProdType3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_TempAlert,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_ButtonSleep2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ButtonVolUp,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_ButtonVolDn,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_RecoveryKey,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_PwmFan,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_PdRstN,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_SdCd,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_SdWp,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_BtGpio2,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio3,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio4,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_CradleIrq,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_PowVcpuInt,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_Max77621GpuInt,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_Hdmi5VEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchB1En,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_HdmiPdTrEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_WifiRfDisable,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_WifiReset,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_WifiWakeHost,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_ApWakeBt,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtRst,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtWakeAp,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_BtGpio5,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_FanEn,
        nn::gpio::Direction_Output,
        nn::gpio::GpioValue_Low,
    },
    {
        nn::gpio::GpioPadName_UsbSwitchB1Oc,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_High,
    },
    {
        nn::gpio::GpioPadName_HdmiHpd,
        nn::gpio::Direction_Input,
        nn::gpio::GpioValue_Low,
    },
};


} // detail
} // driver
} // gpio
} // nn
