﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fs/fs_TimeStampForDebug.h>
#include <nn/fs/fs_FileSystemForDebug.h>

namespace nn { namespace fs {

Result GetFileTimeStampForDebug(FileTimeStamp* outTimeStamp, const char* path) NN_NOEXCEPT
{
    NN_FS_RESULT_THROW_UNLESS(outTimeStamp != nullptr, ResultNullptrArgument());

    nn::fs::FileTimeStampRaw fileTimeStampRaw;
    NN_FS_RESULT_DO(GetFileTimeStampRawForDebug(&fileTimeStampRaw, path));
    outTimeStamp->isLocalTime  = fileTimeStampRaw.isLocalTime;
    outTimeStamp->create.value = fileTimeStampRaw.create;
    outTimeStamp->modify.value = fileTimeStampRaw.modify;
    outTimeStamp->access.value = fileTimeStampRaw.access;
    NN_RESULT_SUCCESS;
}
}}
