﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/account/account_Api.h>
#include <nn/fs/fs_SaveData.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_Utility.h>

namespace nn { namespace fs {

    Result ReadSaveDataThumbnailFile(Bit64 saveDataOwnerId, const nn::account::Uid& user, void* headerData, size_t headerSize, void* bodyData, size_t bodySize) NN_NOEXCEPT
    {
        return ReadSaveDataThumbnailFile(saveDataOwnerId, ConvertAccountUidToFsUserId(user), headerData, headerSize, bodyData, bodySize);
    }

    Result ReadSaveDataThumbnailFileHeader(Bit64 saveDataOwnerId, const nn::account::Uid& user, void* headerData, size_t headerSize) NN_NOEXCEPT
    {
        return ReadSaveDataThumbnailFileHeader(saveDataOwnerId, ConvertAccountUidToFsUserId(user), headerData, headerSize);
    }

    Result WriteSaveDataThumbnailFile(Bit64 saveDataOwnerId, const nn::account::Uid& user, const void* headerData, size_t headerSize, const void* bodyData, size_t bodySize) NN_NOEXCEPT
    {
        return WriteSaveDataThumbnailFile(saveDataOwnerId, ConvertAccountUidToFsUserId(user), headerData, headerSize, bodyData, bodySize);
    }

    Result WriteSaveDataThumbnailFileHeader(Bit64 saveDataOwnerId, const nn::account::Uid& user, const void* headerData, size_t headerSize) NN_NOEXCEPT
    {
        return WriteSaveDataThumbnailFileHeader(saveDataOwnerId, ConvertAccountUidToFsUserId(user), headerData, headerSize);
    }

    Result CorruptSaveDataThumbnailFileForDebug(Bit64 saveDataOwnerId, const nn::account::Uid& user) NN_NOEXCEPT
    {
        return CorruptSaveDataThumbnailFileForDebug(saveDataOwnerId, ConvertAccountUidToFsUserId(user));
    }

}}
