﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_NintendoNetworkIdFriend.h>
#include <nn/friends/detail/friends_ImplNintendoNetworkIdFriend.h>
#include <nn/friends/detail/friends_ApiDetail.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkAssert.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(NintendoNetworkIdFriend)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(NintendoNetworkIdFriend)

namespace nn { namespace friends {

NintendoNetworkIdFriend::NintendoNetworkIdFriend() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId NintendoNetworkIdFriend::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

const MiiName& NintendoNetworkIdFriend::GetMiiName() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->miiName;
}

const MiiImageUrlParam& NintendoNetworkIdFriend::GetMiiImageUrlParam() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->miiImageUrlParam;
}

nn::Result NintendoNetworkIdFriend::GetMiiImageUrl(Url* outUrl) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUrl);

    NN_RESULT_DO(detail::GetMiiImageUrl(outUrl, CONST_GET_IMPL()->miiImageUrlParam));

    NN_RESULT_SUCCESS;
}

bool NintendoNetworkIdFriend::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
