﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_ApiNotificationSettings.h>
#include <nn/friends/friends_Result.h>
#include <nn/account/account_Api.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace friends {

namespace
{
    const nn::settings::system::FriendPresenceOverlayPermission DefaultFriendPresenceOverlayPermission =
        nn::settings::system::FriendPresenceOverlayPermission_Friends;
}

nn::Result GetNotificationSettings(nn::settings::system::AccountNotificationSettings* outSettings,
    const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outSettings);

    bool isExistence = false;
    NN_RESULT_DO(nn::account::GetUserExistence(&isExistence, uid));

    NN_RESULT_THROW_UNLESS(isExistence, ResultInvalidArgument());

    nn::settings::system::AccountNotificationSettings settings[nn::settings::system::AccountNotificationSettingsCountMax] = {};

    int count = nn::settings::system::GetAccountNotificationSettings(settings, NN_ARRAY_SIZE(settings));

    for (int i  = 0; i < count; ++i)
    {
        if (settings[i].uid == uid)
        {
            if (settings[i].friendPresenceOverlayPermission == nn::settings::system::FriendPresenceOverlayPermission_NotConfirmed)
            {
                settings[i].friendPresenceOverlayPermission = static_cast<int8_t>(DefaultFriendPresenceOverlayPermission);
            }
            *outSettings = settings[i];
            NN_RESULT_SUCCESS;
        }
    }

    nn::settings::system::AccountNotificationSettings defaultSettings = {};

    defaultSettings.uid = uid;
    defaultSettings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendOnline>();
    defaultSettings.flags.Set<nn::settings::system::AccountNotificationFlag::FriendRequest>();
    defaultSettings.friendPresenceOverlayPermission = static_cast<int8_t>(DefaultFriendPresenceOverlayPermission);

    *outSettings = defaultSettings;

    NN_RESULT_SUCCESS;
}

nn::Result SetNotificationSettings(const nn::account::Uid& uid, const nn::settings::system::AccountNotificationSettings& settings) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(uid, settings.uid);

    nn::account::Uid uids[nn::account::UserCountMax] = {};
    int count = 0;

    NN_RESULT_DO(nn::account::ListAllUsers(&count, uids, NN_ARRAY_SIZE(uids)));

    nn::settings::system::AccountNotificationSettings currentSettings[nn::settings::system::AccountNotificationSettingsCountMax] = {};

    int currentSettingsCount = nn::settings::system::GetAccountNotificationSettings(currentSettings, NN_ARRAY_SIZE(currentSettings));

    nn::settings::system::AccountNotificationSettings newSettings[nn::settings::system::AccountNotificationSettingsCountMax] = {};
    int newSettingsCount = 0;

    bool isFound = false;

    for (int i = 0; i < count; i++)
    {
        if (uids[i] == uid)
        {
            newSettings[newSettingsCount++] = settings;
            isFound = true;
        }
        else
        {
            for (int c = 0; c < currentSettingsCount; c++)
            {
                if (uids[i] == currentSettings[c].uid)
                {
                    newSettings[newSettingsCount++] = currentSettings[c];
                    break;
                }
            }
        }
    }

    NN_RESULT_THROW_UNLESS(isFound, ResultInvalidArgument());

    nn::settings::system::SetAccountNotificationSettings(newSettings, newSettingsCount);

    NN_RESULT_SUCCESS;
}

}}
