﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/util/friends_ApplicationInfo.h>
#include <nn/arp/arp_Api.h>
#include <nn/ns/ns_ApplicationManagerApi.h>

NN_PRAGMA_PUSH_WARNINGS
NN_DISABLE_WARNING_DEPRECATED_DECLARATIONS

namespace nn { namespace friends { namespace detail { namespace service { namespace util {

namespace
{
    nn::os::SdkMutexType g_Mutex = NN_OS_SDK_MUTEX_INITIALIZER();

    nn::arp::ApplicationLaunchProperty g_AppLaunchProperty;
    nn::ns::ApplicationControlProperty g_AppControlProperty;
}

nn::Result GetApplicationInfo(ApplicationInfo* outInfo, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outInfo);

    nn::os::ProcessId osProcessId = {processId};

    std::lock_guard<decltype (g_Mutex)> lock(g_Mutex);

    NN_RESULT_TRY(nn::arp::GetApplicationLaunchProperty(&g_AppLaunchProperty, osProcessId))
        NN_RESULT_CATCH_ALL
        {
            NN_RESULT_THROW(ResultApplicationInfoNotRegistered());
        }
    NN_RESULT_END_TRY;

    NN_RESULT_TRY(nn::arp::GetApplicationControlProperty(&g_AppControlProperty, osProcessId))
        NN_RESULT_CATCH_ALL
        {
            NN_RESULT_THROW(ResultApplicationInfoNotRegistered());
        }
    NN_RESULT_END_TRY;

    outInfo->appId.value = g_AppLaunchProperty.id.value;
    outInfo->presenceGroupId = g_AppControlProperty.presenceGroupId.value;

    NN_RESULT_SUCCESS;
}

nn::Result GetUserLastOpenedApplicationInfo(ApplicationInfo* outInfo, const nn::account::Uid& uid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outInfo);

    std::memset(outInfo, 0, sizeof (ApplicationInfo));

    nn::ApplicationId appId;
    uint32_t version;

    NN_RESULT_DO(nn::account::GetUserLastOpenedApplication(&appId, &version, uid));

    std::lock_guard<decltype (g_Mutex)> lock(g_Mutex);

    NN_RESULT_DO(nn::arp::GetApplicationControlProperty(&g_AppControlProperty, appId));

    outInfo->appId = appId;
    outInfo->presenceGroupId = g_AppControlProperty.presenceGroupId.value;

    NN_RESULT_SUCCESS;
}

}}}}}

NN_PRAGMA_POP_WARNINGS
