﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/json/friends_JsonPatchGenerator.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace json {

bool JsonPatchGenerator::BeginWrite(JsonWriter& writer) NN_NOEXCEPT
{
    return writer.StartArray();
}

bool JsonPatchGenerator::EndWrite(JsonWriter& writer) NN_NOEXCEPT
{
    return writer.EndArray();
}

bool JsonPatchGenerator::BeginWriteAddOperation(JsonWriter& writer, const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(path);

    if (!writer.StartObject())
    {
        return false;
    }
    if (!writer.Key("op") || !writer.String("add"))
    {
        return false;
    }
    if (!writer.Key("path") || !writer.String(path))
    {
        return false;
    }
    if (!writer.Key("value"))
    {
        return false;
    }

    return true;
}

bool JsonPatchGenerator::EndWriteAddOperation(JsonWriter& writer) NN_NOEXCEPT
{
    if (!writer.EndObject())
    {
        return false;
    }

    return true;
}

bool JsonPatchGenerator::BeginWriteReplaceOperation(JsonWriter& writer, const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(path);

    if (!writer.StartObject())
    {
        return false;
    }
    if (!writer.Key("op") || !writer.String("replace"))
    {
        return false;
    }
    if (!writer.Key("path") || !writer.String(path))
    {
        return false;
    }
    if (!writer.Key("value"))
    {
        return false;
    }

    return true;
}

bool JsonPatchGenerator::EndWriteReplaceOperation(JsonWriter& writer) NN_NOEXCEPT
{
    if (!writer.EndObject())
    {
        return false;
    }

    return true;
}

bool JsonPatchGenerator::WriteMoveOperation(JsonWriter& writer, const char* from, const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(from);
    NN_SDK_REQUIRES_NOT_NULL(path);

    if (!writer.StartObject())
    {
        return false;
    }
    if (!writer.Key("op") || !writer.String("move"))
    {
        return false;
    }
    if (!writer.Key("from") || !writer.String(from))
    {
        return false;
    }
    if (!writer.Key("path") || !writer.String(path))
    {
        return false;
    }
    if (!writer.EndObject())
    {
        return false;
    }

    return true;
}

bool JsonPatchGenerator::WriteCopyOperation(JsonWriter& writer, const char* from, const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(from);
    NN_SDK_REQUIRES_NOT_NULL(path);

    if (!writer.StartObject())
    {
        return false;
    }
    if (!writer.Key("op") || !writer.String("copy"))
    {
        return false;
    }
    if (!writer.Key("from") || !writer.String(from))
    {
        return false;
    }
    if (!writer.Key("path") || !writer.String(path))
    {
        return false;
    }
    if (!writer.EndObject())
    {
        return false;
    }

    return true;
}

bool JsonPatchGenerator::WriteRemoveOperation(JsonWriter& writer, const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(path);

    if (!writer.StartObject())
    {
        return false;
    }
    if (!writer.Key("op") || !writer.String("remove"))
    {
        return false;
    }
    if (!writer.Key("path") || !writer.String(path))
    {
        return false;
    }
    if (!writer.EndObject())
    {
        return false;
    }

    return true;
}

}}}}}
