﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/friends_ServiceCreator.h>
#include <nn/friends/detail/service/friends_FriendService.h>
#include <nn/friends/detail/service/friends_NotificationService.h>
#include <nn/friends/detail/service/friends_DaemonSuspendSessionService.h>
#include <nn/friends/detail/service/friends_Common.h>
#include <nn/friends/detail/service/core/friends_ServiceMemoryManager.h>
#include <nn/sf/sf_ObjectFactory.h>

#define CHECK_UID(uid) \
    NN_RESULT_THROW_UNLESS(uid, ResultInvalidArgument())

namespace nn { namespace friends { namespace detail { namespace service {

ServiceCreator::ServiceCreator(const char* serviceName, const Capability& capability) NN_NOEXCEPT :
    m_ServiceName(serviceName),
    m_Capability(capability)
{
    NN_UNUSED(m_ServiceName);
}

ServiceCreator::~ServiceCreator() NN_NOEXCEPT
{
}

nn::Result ServiceCreator::CreateFriendService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IFriendService>> outService) NN_NOEXCEPT
{
    auto& allocator = detail::service::core::ServiceMemoryManager::GetInstance().GetFriendServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IFriendService, FriendService>(&allocator, m_Capability);

    // NN_DETAIL_FRIENDS_INFO("[friends] Create friend service. (%s)\n", m_ServiceName ? m_ServiceName : "");

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreator::CreateNotificationService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::INotificationService>> outService, const nn::account::Uid& uid) NN_NOEXCEPT
{
    CHECK_UID(uid);

    auto& allocator = detail::service::core::ServiceMemoryManager::GetInstance().GetNotificationServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::INotificationService, NotificationService>(&allocator, m_Capability, uid);

    // NN_DETAIL_FRIENDS_INFO("[friends] Create notification service. (%s)\n", m_ServiceName ? m_ServiceName : "");

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreator::CreateDaemonSuspendSessionService(nn::sf::Out<nn::sf::SharedPointer<nn::friends::detail::ipc::IDaemonSuspendSessionService>> outService) NN_NOEXCEPT
{
    auto& allocator = detail::service::core::ServiceMemoryManager::GetInstance().GetDaemonSuspendSessionServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IDaemonSuspendSessionService, DaemonSuspendSessionService>(&allocator, m_Capability);

    // NN_DETAIL_FRIENDS_INFO("[friends] Create daemon suspend session service. (%s)\n", m_ServiceName ? m_ServiceName : "");

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

}}}}
