﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetSnsAccountProfile.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerSnsAccountProfile.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerErrorFrs.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetSnsAccountProfileTask::GetSnsAccountProfileTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result GetSnsAccountProfileTask::SetParameter(SnsAccountProfile* outProfile,
    nn::account::NetworkServiceAccountId accountId, SnsAccountType type) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(type == SnsAccountType_Facebook || type == SnsAccountType_Twitter, ResultInvalidArgument());

    m_OutProfile = outProfile;

    m_AccountId = accountId;
    m_Type = type;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountProfileTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(StepGetIdToken());

    NN_RESULT_TRY(StepGetProfile())
        NN_RESULT_CATCH(ResultFriendRecommendServerInvalidIdToken)
        {
            NN_DETAIL_FRIENDS_INFO("[friends] The IdToken cache was judged invalidity.\n");

            Account::ClearNintendoAccountIdTokenForFriendCandidate();

            NN_RESULT_DO(StepGetIdToken());
            NN_RESULT_DO(StepGetProfile());
        }
    NN_RESULT_END_TRY;

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountProfileTask::StepGetIdToken() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetSnsAccountProfileTask::StepGetIdToken ...\n");

    NN_RESULT_DO(Account::GetNintendoAccountIdTokenForFriendCandidate(&m_IdToken, GetUid(), GetCancelable()));

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountProfileTask::StepGetProfile() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetSnsAccountProfileTask::StepGetProfile ...\n");
    detail::service::json::JsonHttpInputStream stream;

    char url[2048] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://api-%%.frs.srv.nintendo.net/v1/profile?id_token=%s&network_service_account_id=%016llx&type=%s",
        m_IdToken.value, m_AccountId.id, m_Type == SnsAccountType_Facebook ? "facebook" : "twitter");

    NN_RESULT_DO(stream.Open("GET", url));

    SnsAccountProfileHandler okHandler;
    FrsErrorHandler errorHandler;

    okHandler.Initialize(m_OutProfile);

    NN_RESULT_DO(WebApi::Call(okHandler, errorHandler, stream, GetUid(), GetCancelable(), false));

    NN_RESULT_SUCCESS;
}

}}}}}
