﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetFriendCandidateList.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerFriendCandidateResourceList.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerErrorFrs.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetFriendCandidateListTask::GetFriendCandidateListTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result GetFriendCandidateListTask::SetParameter(int* outCount, FriendCandidateImpl* outCandidates,
    int count, FriendCandidateType type) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(count > 0, ResultInvalidArgument());

    NN_RESULT_THROW_UNLESS(type == FriendCandidateType_ExternalApplication, ResultInvalidArgument());

    m_OutCount = outCount;
    m_OutCandidates = outCandidates;

    m_Count = count;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result GetFriendCandidateListTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(StepGetIdToken());

    NN_RESULT_TRY(StepGetList())
        NN_RESULT_CATCH(ResultFriendRecommendServerInvalidIdToken)
        {
            NN_DETAIL_FRIENDS_INFO("[friends] The IdToken cache was judged invalidity.\n");

            Account::ClearNintendoAccountIdTokenForFriendCandidate();

            NN_RESULT_DO(StepGetIdToken());
            NN_RESULT_DO(StepGetList());
        }
    NN_RESULT_END_TRY;

    NN_RESULT_SUCCESS;
}

nn::Result GetFriendCandidateListTask::StepGetIdToken() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetFriendCandidateListTask::StepGetIdToken ...\n");

    NN_RESULT_DO(Account::GetNintendoAccountIdTokenForFriendCandidate(&m_IdToken, GetUid(), GetCancelable()));

    NN_RESULT_SUCCESS;
}

nn::Result GetFriendCandidateListTask::StepGetList() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetFriendCandidateListTask::StepGetList ...\n");

    detail::service::json::JsonHttpInputStream stream;

    char url[2048] = {};
    nn::util::SNPrintf(url, sizeof (url), "https://api-%%.frs.srv.nintendo.net/v1/friend_recommendations?id_token=%s&type=nintendo_account",
        m_IdToken.value);

    NN_RESULT_DO(stream.Open("GET", url));

    FriendCandidateResourceListHandler okHandler;
    FrsErrorHandler errorHandler;
    okHandler.Initialize(m_OutCount, m_OutCandidates, m_Count);

    NN_RESULT_DO(WebApi::Call(okHandler, errorHandler, stream, GetUid(), GetCancelable(), false));

    NN_RESULT_SUCCESS;
}

}}}}}
