﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerRelationship.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

RelationshipHandler::RelationshipHandler() NN_NOEXCEPT :
    m_OutRelationship(nullptr),
    m_Bits()
{
}

void RelationshipHandler::Initialize(Relationship* outRelationship) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outRelationship);

    m_OutRelationship = outRelationship;

    std::memset(m_OutRelationship, 0, sizeof (Relationship));
}

bool RelationshipHandler::OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT
{
    if (!m_Bits.isFriend &&
        jsonPath.Compare("$.isFriend"))
    {
        m_Bits.isFriend = true;
        m_OutRelationship->isFriend = value;
    }
    else if (!m_Bits.isFriendOfFriend &&
        jsonPath.Compare("$.isFOAF"))
    {
        m_Bits.isFriendOfFriend = true;
        m_OutRelationship->isFriendOfFriend = value;
    }
    else if (!m_Bits.isBlocked &&
        jsonPath.Compare("$.isBlocking"))
    {
        m_Bits.isBlocked = true;
        m_OutRelationship->isBlocked = value;
    }

    return true;
}

bool RelationshipHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(length);
    NN_UNUSED(isOverflowed);

    if (!m_Bits.isRequestPending &&
        jsonPath.Compare("$.sentFriendRequestIds[0]"))
    {
        m_Bits.isRequestPending = true;
        m_OutRelationship->isRequestPending = true;
    }

    return true;
}

}}}}}
