﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/friends_WorkBuffer.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

WorkBuffer::WorkBuffer() NN_NOEXCEPT :
    m_Mutex(true)
{
}

bool WorkBuffer::TryAcquire() NN_NOEXCEPT
{
    return m_Mutex.TryLock();
}

bool WorkBuffer::Acquire(const detail::service::util::Cancelable& cancelable) NN_NOEXCEPT
{
    while (!TryAcquire())
    {
        if (cancelable.IsCanceled())
        {
            return false;
        }

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(5));
    }

    return true;
}

void WorkBuffer::Release() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Mutex.IsLockedByCurrentThread());

    m_Mutex.Unlock();
}

void* WorkBuffer::Get() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_Mutex.IsLockedByCurrentThread());

    return m_Buffer;
}

size_t WorkBuffer::GetSize() const NN_NOEXCEPT
{
    return Size;
}

}}}}}
