﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/friends_NotificationEventHandler.h>
#include <nn/friends/detail/service/friends_NotificationService.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

NotificationEventHandler::NotificationEventHandler() NN_NOEXCEPT :
    m_Mutex(true)
{
    std::memset(m_Notifications, 0, sizeof (m_Notifications));
}

void NotificationEventHandler::Attach(NotificationService* notification) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(notification);

    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < NN_ARRAY_SIZE(m_Notifications); i++)
    {
        if (!m_Notifications[i])
        {
            m_Notifications[i] = notification;
            break;
        }
    }
}

void NotificationEventHandler::Detach(NotificationService* notification) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(notification);

    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < NN_ARRAY_SIZE(m_Notifications); i++)
    {
        if (m_Notifications[i] == notification)
        {
            m_Notifications[i] = nullptr;
            break;
        }
    }
}

void NotificationEventHandler::NotifyFriendListUpdated(const nn::account::Uid& uid) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < NN_ARRAY_SIZE(m_Notifications); i++)
    {
        if (m_Notifications[i])
        {
            m_Notifications[i]->NotifyFriendListUpdated(uid);
        }
    }
}

void NotificationEventHandler::NotifyFriendPresenceUpdated(const nn::account::Uid& uid, nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < NN_ARRAY_SIZE(m_Notifications); i++)
    {
        if (m_Notifications[i])
        {
            m_Notifications[i]->NotifyFriendPresenceUpdated(uid, accountId);
        }
    }
}

void NotificationEventHandler::NotifyFriendRequestReceived(const nn::account::Uid& uid) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    for (int i = 0; i < NN_ARRAY_SIZE(m_Notifications); i++)
    {
        if (m_Notifications[i])
        {
            m_Notifications[i]->NotifyFriendRequestReceived(uid);
        }
    }
}

}}}}}
