﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/friends_ForegroundTaskThread.h>
#include <nn/friends/detail/service/core/friends_ForegroundTaskManager.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

namespace
{
    nn::os::ThreadType g_Threads[ForegroundTaskManager::RunnableTaskCountMax] = {};
    NN_OS_ALIGNAS_THREAD_STACK nn::Bit8 g_ThreadStacks[ForegroundTaskManager::RunnableTaskCountMax][64 * 1024];

    nn::os::Event g_StopEvent(nn::os::EventClearMode_ManualClear);
}

namespace
{
    void WorkerThread(void*) NN_NOEXCEPT
    {
        nn::os::EventType* event = ForegroundTaskManager::GetInstance().AcquireRunnableTaskEvent();

        while (NN_STATIC_CONDITION(true))
        {
            nn::os::WaitAny(g_StopEvent.GetBase(), event);

            if (g_StopEvent.TryWait())
            {
                break;
            }

            nn::os::ClearEvent(event);

            ForegroundTaskManager::GetInstance().RunRunnable();
        }

        ForegroundTaskManager::GetInstance().ReleaseRunnableTaskEvent(event);
    }
}

void ForegroundTaskThread::Start() NN_NOEXCEPT
{
    for (int i = 0; i < NN_ARRAY_SIZE(g_Threads); i++)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_Threads[i], WorkerThread, nullptr,
            g_ThreadStacks[i], sizeof (g_ThreadStacks[i]), NN_SYSTEM_THREAD_PRIORITY(friends, ForegroundTask)));

        nn::os::SetThreadNamePointer(&g_Threads[i], NN_SYSTEM_THREAD_NAME(friends, ForegroundTask));
        nn::os::StartThread(&g_Threads[i]);
    }
}

void ForegroundTaskThread::Stop() NN_NOEXCEPT
{
    g_StopEvent.Signal();

    for (int i = 0; i < NN_ARRAY_SIZE(g_Threads); i++)
    {
        nn::os::DestroyThread(&g_Threads[i]);
    }
}

}}}}}
