﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/fgm/fgm_Types.h>
#include <nn/psc.h>

namespace nn     {
namespace fgm    {
namespace server {

class Resource;

// Implements controls for a single PM resource request.
class Request :
    public nn::util::IntrusiveListBaseNode<Request>,
    public nn::sf::ISharedObject
{
private:
    Module                  m_Id;
    Resource*               m_Resource;
    nn::os::SystemEvent     m_SystemEvent;
    Setting                 m_Min;
    Setting                 m_Max;
    const Priority          m_Priority;
    nn::os::Mutex           m_Lock;
    nn::os::ProcessId       m_Pid;
    static nn::psc::PmState m_PmState;

public:
    static void SetPmState(nn::psc::PmState state) NN_NOEXCEPT { m_PmState = state; }
    nn::os::ProcessId GetPid() const NN_NOEXCEPT { return m_Pid; }
    Module     GetId()  const NN_NOEXCEPT { return m_Id;  }
    Setting    GetMin() const NN_NOEXCEPT { return m_Min; }
    Setting    GetMax() const NN_NOEXCEPT { return m_Max; }
    Priority   GetPriority() const NN_NOEXCEPT { return m_Priority; }
    void       Update(Setting min, Setting max) NN_NOEXCEPT { m_Min = min; m_Max = max; }
    nn::Result Signal() NN_NOEXCEPT;
    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, Module moduleId, nn::Bit64 pid) NN_NOEXCEPT;
    nn::Result Set(Setting min, Setting max) NN_NOEXCEPT;
    nn::Result Get(nn::sf::Out<uint32_t> pSetting) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;

    explicit Request(Priority priority)  NN_NOEXCEPT;
    ~Request() NN_NOEXCEPT;
};

}}}
