﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_SystemEvent.h>
#include <nn/settings/system/settings_Fatal.h>

#include "fatalsrv_Settings.h"
#include "fatalsrv_Environment.h"

namespace nn { namespace fatalsrv {

    nn::os::MultiWaitHolderType* SettingsEventManager::GetEventWaitHolder() NN_NOEXCEPT
    {
        if (!m_Initialized)
        {
            nn::settings::system::BindFatalDirtyFlagEvent(
                &m_Event, nn::os::EventClearMode::EventClearMode_ManualClear);
            nn::os::InitializeMultiWaitHolder(&m_MultiWaitHolder, &m_Event);
            nn::os::SetMultiWaitHolderUserData(&m_MultiWaitHolder, reinterpret_cast<uintptr_t>(&m_MultiWaitHolder));
            m_Initialized = true;
        }
        return &m_MultiWaitHolder;
    }

    void SettingsEventManager::OnSettingsUpdated() NN_NOEXCEPT
    {
        nn::os::ClearSystemEvent(&m_Event);

        nn::settings::system::FatalDirtyFlagSet flags;
        nn::settings::system::GetFatalDirtyFlags(&flags);

        if (flags.Test<nn::settings::system::FatalDirtyFlag::LanguageCode>())
        {
            UpdateLanguageCode();
        }
    }

}} // namespace nn::fatalsrv
