﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fatalsrv/fatalsrv_CpuContext.h>
#include <nn/fatalsrv/fatalsrv_FatalContext.h>
#include <nn/fatalsrv/fatalsrv_Service.h>
#include "fatalsrv_Font.h"
#include "fatalsrv_Color.h"
#include "fatalsrv_Task.h"

namespace nn { namespace fatalsrv {
    Result ShowFatalScreen(const FatalContext& context, const CpuContext& cpuContext, nn::Bit64 callerProgramId) NN_NOEXCEPT;
    Result DrawDebugScreen(TextRenderer& renderer, const FatalContext& fatalContext, const CpuContext& cpuContext, nn::Bit64 callerProgramId) NN_NOEXCEPT;
    void SwitchBacklightOn() NN_NOEXCEPT;

    ITask* InitializeAndGetBacklightControlTask() NN_NOEXCEPT;
    ITask* InitializeAndGetFatalScreenTask(const Service::Context& context, nn::Bit64 callerProgramId, nn::os::Event* batteryCheckedEvent) NN_NOEXCEPT;
}} // namespace nn::fatalsrv
