﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fatalsrv/fatalsrv_CpuContext.h>
#include <nn/os/os_UserExceptionHandlerTypes.h>
#include <nn/fatal/fatal_ApiPrivate.h>
#include <string>

#define MAKE_EXCEPTION_TYPE_ENTRY(exceptionType) {static_cast<Bit32>(nn::os:: exceptionType), #exceptionType}

namespace nn { namespace fatal {
    namespace {
        struct ExceptionTypeEntry
        {
            nn::Bit32 value;
            const char* name;
        };

        ExceptionTypeEntry g_ExceptionTypeEntryTable[] =
        {
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_None),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_InvalidInstructionAccess),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_InvalidDataAccess),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_UnalignedInstructionAccess),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_UnalignedDataAccess),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_UndefinedInstruction),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_ExceptionalInstruction),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_MemorySystemError),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_FloatingPointException),
            MAKE_EXCEPTION_TYPE_ENTRY(UserExceptionType_InvalidSystemCall),
        };
        const int ExceptionTypeTableCount = sizeof(g_ExceptionTypeEntryTable) / sizeof(ExceptionTypeEntry);
        const char* ExceptionTypeAbort = "Abort";
        const char* ExceptionTypeUnknown = "Unknown";
    } // namespace

    const char* GetExceptionName(nn::Bit32 exceptionType) NN_NOEXCEPT
    {
        const char* SkipString = "UserExceptionType_";

        for (int i = 0; i < ExceptionTypeTableCount; ++i)
        {
            auto& e = g_ExceptionTypeEntryTable[i];
            if (exceptionType == 0)
            {
                return ExceptionTypeAbort;
            }
            else if (exceptionType == e.value)
            {
                return e.name + std::strlen(SkipString);
            }
        }
        return ExceptionTypeUnknown;
    }
}} // namespace nn::fatal
