﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// ファンデバイス固有のリソースを確保し、その参照を提供する機能

#include <nn/nn_Common.h>
#include <nn/util/util_TypedStorage.h>

#include "fan_DeviceAccessor.h"
#include "fan_SettingsHolder.h"

namespace nn {
namespace fan {
namespace impl {
namespace detail {

namespace {
    // StorageForDeviceAccessor のサイズを算出するための構造体
    // DeviceAccessor を継承するクラスを追加した際は、必ずここにも追加すること
    struct StorageForDeviceAccessorImpl
    {
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
        union
        {
            DeviceAccessorDummy deviceAccessorDummy;
            DeviceAccessorPwm   deviceAccessorPwm;
            DeviceAccessorGpio  deviceAccessorGpio;
        };
#else
        union
        {
            DeviceAccessorDummy deviceAccessorDummy;
        };
#endif
    };
}

typedef util::TypedStorage< DeviceAccessor,
                     sizeof(StorageForDeviceAccessorImpl),
                 NN_ALIGNOF(DeviceAccessor) >
                            StorageForDeviceAccessor;

class ControllerHolder
{
    NN_DISALLOW_COPY(ControllerHolder);
    NN_DISALLOW_MOVE(ControllerHolder);

    friend ControllerHolder* AllocControllerHolder(FanName, SettingsHolder&) NN_NOEXCEPT;
    friend void FreeControllerHolder(ControllerHolder*) NN_NOEXCEPT;
    friend void NotifyElapsedTime(int64_t elapsedTimeUsec) NN_NOEXCEPT;
    friend void SetFanEnabledFromServer(bool enabled) NN_NOEXCEPT;

public:
    ControllerHolder() NN_NOEXCEPT : m_RefCount(0) {}
    ~ControllerHolder() NN_NOEXCEPT {}

    void* GetDeviceAccessorHolder() NN_NOEXCEPT
    {
        return reinterpret_cast<void*>(&m_DeviceAccessorHolder);
    }

private:
    StorageForDeviceAccessor m_DeviceAccessorHolder;

    // friend である AllocControllerHolder / FreeControllerHolder が操作する
    int m_RefCount;
};

ControllerHolder* AllocControllerHolder(FanName name, SettingsHolder&) NN_NOEXCEPT;
void FreeControllerHolder(ControllerHolder* pControllerHolder) NN_NOEXCEPT;
void NotifyElapsedTime(int64_t elapsedTimeUsec) NN_NOEXCEPT;
void SetFanEnabledFromServer(bool enabled) NN_NOEXCEPT;

} // detail
} // impl
} // fan
} // nn
