﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_SdkLog.h>

#include <nn/eupld/eupld_Result.h>
#include <nn/eupld/server/eupld_Result.http.h>

#include <nn/dauth/dauth_Api.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/system/settings_FirmwareVersion.h>
#include <nn/util/util_FormatString.h>

#include "eupldsrv_Transport.h"
#include "eupldsrv_CurlErrorHandler.h"

namespace nn    {
namespace eupld {
namespace srv   {
namespace       {

CURLcode SslCallback(CURL* pCurl, void* pSslContext, void* pUserData)
NN_NOEXCEPT
{
    nn::Result           result;
    nn::ssl::CertStoreId deviceCertId;
    nn::ssl::Context*    pContext = reinterpret_cast<nn::ssl::Context*>(pSslContext);

    if ((result = pContext->Create(nn::ssl::Context::SslVersion_Auto)).IsFailure() ||
        (result = pContext->RegisterInternalPki(&deviceCertId, nn::ssl::Context::InternalPki_DeviceClientCertDefault)).IsFailure())
    {
        NN_SDK_LOG("[eupld]: failed to initialize SSL context - %d:%d\n", result.GetModule(), result.GetDescription());
        return CURLE_ABORTED_BY_CALLBACK;
    }

    return CURLE_OK;
}

} // namespace

nn::Result Transport::SetupCurlHandle(CURL* pCurlHandleIn)
NN_NOEXCEPT
{
    CURLcode curlError;

    #if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    // do not verify peer and host
    if ((curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_SKIP_DEFAULT_VERIFY, 1L)) != CURLE_OK ||
        (curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_VERIFYPEER, 0L)) != CURLE_OK ||
        (curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_VERIFYHOST, 0L)) != CURLE_OK ||
        (curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_CTX_FUNCTION, SslCallback)) != CURLE_OK)
    #else
    if ((curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_VERIFYPEER, 1L)) != CURLE_OK ||
        (curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_VERIFYHOST, 2L)) != CURLE_OK ||
        (curlError = curl_easy_setopt(pCurlHandleIn, CURLOPT_SSL_CTX_FUNCTION, SslCallback)) != CURLE_OK)
    #endif
    {
        return HandleCurlError(curlError);
    }

    return ResultSuccess();
}

}}}
