﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/erpt/erpt_Report.h>
#include <nn/eupld/eupld_Types.h>

namespace nn    {
namespace eupld {
namespace srv   {

const   uint8_t Tag_Array16384 = 0xdc;
typedef uint8_t ArrayHeader[3];

class ReportStream
{
private:
    nn::erpt::Report  m_Report[nn::erpt::NumberOfReports];
    ReportUploadList* m_pList;
    int32_t           m_CurrentReportIndex;
    nn::Result        m_Result;
    uint32_t          m_TotalSize;
    uint32_t          m_ReportCount;
    bool              m_AddHeader;
    bool              m_AutoUpload;

public:
    nn::Result Read(uint32_t* pReadCountOut, uint8_t* pBuffer, uint32_t size)
    NN_NOEXCEPT;

    uint32_t GetStreamSize()
    NN_NOEXCEPT;

    void MarkAsTransmitted()
    NN_NOEXCEPT;

    explicit ReportStream(ReportUploadList* pList, bool autoUpload)
    NN_NOEXCEPT;

    ~ReportStream()
    NN_NOEXCEPT;
};

}}}
