﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/time.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include "eupldsrv_Worker.h"
#include "eupldsrv_Service.h"
#include "eupldsrv_Transport.h"

namespace nn    {
namespace eupld {
namespace srv   {

nn::lmem::HeapHandle     g_HeapHandle;
nn::sf::ExpHeapAllocator g_ServiceFrameworkAllocator;
nn::eupld::srv::Worker   g_Worker;

nn::Result Initialize(uint8_t* pMemoryIn, size_t memorySize)
NN_NOEXCEPT
{
    nn::Result result;

    g_HeapHandle = nn::lmem::CreateExpHeap(
                    pMemoryIn,
                    memorySize,
                    nn::lmem::CreationOption_ThreadSafe);

    NN_ABORT_UNLESS(g_HeapHandle != nullptr);

    g_ServiceFrameworkAllocator.Attach(g_HeapHandle);

    g_Worker.Start();

    return InitializeService();
}

void Finalize()
NN_NOEXCEPT
{
    g_Worker.Stop();
}

nn::Result SetUrl(const char* pUrlString, uint32_t urlLength)
NN_NOEXCEPT
{
    return Transport::SetUrl(pUrlString, urlLength);
}

void Wait()
NN_NOEXCEPT
{
    g_Worker.HandlePmEvents();
}

}}}
