﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/es/es_LocalConcurrencyCheckApi.h>
#include "es_ETicketServiceObject.h"

namespace nn { namespace es {

Result GetChallengeOfLocalConcurrencyCheck(LocalConcurrencyCheckChallenge* outValue) NN_NOEXCEPT
{
    return GetETicketServiceObject()->GetChallengeOfLocalConcurrencyCheck(outValue);
}

Result AuthorizeLocalConcurrencyCheckData(LocalConcurrencyCheckAuthenticationInfo* outInfo, const LocalConcurrencyCheckData authenticatedDataList[], int authenticatedDataListCount, const LocalConcurrencyCheckData& unauthenticatedData) NN_NOEXCEPT
{
    sf::InArray<LocalConcurrencyCheckData> pInAuthenticatedDataList(authenticatedDataList, static_cast<size_t>(authenticatedDataListCount));

    return GetETicketServiceObject()->AuthorizeLocalConcurrencyCheckData(outInfo, pInAuthenticatedDataList, unauthenticatedData);
}

Result GetLocalConcurrencyCheckData(LocalConcurrencyCheckData* outData, const LocalConcurrencyCheckChallenge& challenge) NN_NOEXCEPT
{
    return GetETicketServiceObject()->GetLocalConcurrencyCheckData(outData, challenge);
}

Result VerifyLocalConcurrencyAuthentication(const LocalConcurrencyCheckAuthenticationInfo& info) NN_NOEXCEPT
{
    return GetETicketServiceObject()->VerifyLocalConcurrencyAuthentication(info);
}

}}

