﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace es {

    // 乱数を生成します。
    Result GenerateRandomBytes(void* pOutBuffer, size_t bufferSize) NN_NOEXCEPT;

    // AES-CBS-PKCS#7 暗号化がされた暗号文のサイズを取得します。
    size_t CalculateEncryptionTextSizeAes128CbcWithPkcs7Padding(size_t plainSize) NN_NOEXCEPT;

    size_t EncryptAes128CbcWithPkcs7Padding(void* pDst, size_t dstSize,
                        const void* pKey, size_t keySize,
                        const void* pIv, size_t ivSize,
                        const void* pSrc, size_t srcSize) NN_NOEXCEPT;

    bool EncryptRsa2048OaepSha256(void* pOutCipher, size_t cipherSize,
        const void* pModulus, size_t modulusSize,
        const void* pPublicExponent, size_t publicExponentSize,
        const void* pRawMessage, size_t rawMessageSize,
        const void* pLabel, size_t labelSize) NN_NOEXCEPT;

}} // namespace nn::es
