﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/settings/factory/settings_DeviceCertificate.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace es {

class Rsa2048DevicePublicKey
{
public:
    Rsa2048DevicePublicKey() NN_NOEXCEPT
    {
#ifdef NN_BUILD_CONFIG_OS_HORIZON
        NN_ABORT_UNLESS_RESULT_SUCCESS(settings::factory::GetEticketDeviceCertificate(&m_DeviceCertificate));
#else

        // PC用デバイス証明書(6100000000000004_dev-ticket-rsa2048.cert)
        const uint8_t DeviceCertificate[] =
        {
            0x00, 0x01, 0x00, 0x05, 0x00, 0xDB, 0x95, 0x5A, 0x54, 0x9C, 0xA6, 0x3A, 0xAA, 0x0D, 0x14,
            0x73, 0x7A, 0x16, 0x89, 0x67, 0xAC, 0xEB, 0x8D, 0xE1, 0x12, 0x6C, 0x6C, 0x6A, 0xA3, 0xAF,
            0x6C, 0xBB, 0xD2, 0x0B, 0x00, 0x00, 0x40, 0xE2, 0xD8, 0x66, 0xB0, 0x84, 0x72, 0xEB, 0xB3,
            0x77, 0x9B, 0x2B, 0x79, 0xF9, 0xD9, 0x69, 0x26, 0x64, 0xF4, 0xCC, 0x14, 0xEA, 0x37, 0x95,
            0xF2, 0x1D, 0xCE, 0xBD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4E, 0x69, 0x6E, 0x74, 0x65, 0x6E, 0x64,
            0x6F, 0x4E, 0x58, 0x43, 0x41, 0x31, 0x44, 0x65, 0x76, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x4E, 0x58, 0x36, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30,
            0x30, 0x30, 0x30, 0x34, 0x2D, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE7, 0x98, 0xF0, 0xC3, 0x7A, 0x3F, 0x6B, 0xFB, 0xB9,
            0xD7, 0x8B, 0x23, 0xD7, 0xB5, 0x70, 0x5D, 0x47, 0x0C, 0x93, 0xCA, 0xCD, 0xBF, 0x89, 0x52,
            0x87, 0x1E, 0xAA, 0xA3, 0xC2, 0xFB, 0x7D, 0x77, 0x84, 0x84, 0xF0, 0xD7, 0x08, 0x40, 0x95,
            0xD8, 0xB0, 0x61, 0x17, 0x37, 0x66, 0x04, 0x57, 0x0F, 0xF9, 0xCF, 0xDD, 0x11, 0x1E, 0xD2,
            0x80, 0x13, 0x0C, 0x39, 0xC2, 0x1B, 0x6C, 0xAF, 0x96, 0xE3, 0xC0, 0x26, 0x90, 0x3D, 0x9B,
            0x09, 0x64, 0xDA, 0x8D, 0xDA, 0xCB, 0xB6, 0x2E, 0xA8, 0x52, 0xEC, 0xC0, 0xBC, 0xBD, 0x74,
            0x34, 0x77, 0xD9, 0x58, 0x8D, 0x5E, 0xED, 0x84, 0x1B, 0x47, 0x9B, 0x4C, 0x60, 0xF4, 0xB6,
            0xD0, 0x29, 0x37, 0xFC, 0xE2, 0x4F, 0x99, 0x28, 0x1E, 0x13, 0xF2, 0x20, 0xA7, 0x17, 0xF0,
            0x53, 0xFB, 0x46, 0xEC, 0xD5, 0x3F, 0x72, 0xA5, 0x4E, 0x6E, 0xF2, 0xC1, 0x5A, 0xEF, 0xAE,
            0x45, 0xE3, 0x6E, 0x83, 0xEB, 0x8C, 0xD9, 0x38, 0x14, 0x54, 0x0B, 0x05, 0x42, 0x92, 0x66,
            0x4C, 0x2B, 0x16, 0x12, 0x9E, 0xE9, 0x09, 0xFC, 0xB4, 0x6D, 0x87, 0x2D, 0xB0, 0xF9, 0xDE,
            0xC8, 0xCD, 0xEC, 0xDE, 0x08, 0x49, 0xC8, 0x45, 0x54, 0x71, 0x40, 0x29, 0xA1, 0x74, 0xB4,
            0xD9, 0x24, 0x19, 0x28, 0x1C, 0xBA, 0xB1, 0x7F, 0xC6, 0xE1, 0xD6, 0x01, 0x75, 0x7C, 0x95,
            0xCA, 0x71, 0x37, 0xF6, 0xD0, 0x37, 0xDD, 0x1F, 0x01, 0xE6, 0x37, 0x42, 0xDF, 0x56, 0x9C,
            0x19, 0x8C, 0x88, 0x9B, 0x92, 0x80, 0x32, 0xF6, 0x0B, 0xDB, 0xE8, 0x98, 0x6D, 0xD3, 0x4C,
            0x93, 0x8F, 0xD6, 0x95, 0x44, 0xEB, 0xC5, 0x43, 0x80, 0xAC, 0x4A, 0x00, 0x87, 0xD5, 0xFB,
            0xCB, 0x40, 0x3B, 0xA5, 0x4D, 0x65, 0x96, 0x77, 0x66, 0xE8, 0xD8, 0x51, 0xD8, 0x68, 0xF6,
            0x60, 0x1F, 0xBD, 0x19, 0x75, 0x5D, 0x73, 0x17, 0x20, 0x2F, 0x00, 0x01, 0x00, 0x01, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };

        memcpy(m_DeviceCertificate.data, DeviceCertificate, sizeof(m_DeviceCertificate.data));
#endif // NN_BUILD_CONFIG_OS_HORIZON
    }

    const uint8_t* GetModulus() const NN_NOEXCEPT
    {
        return &m_DeviceCertificate.data[DeviceCertificateModulusOffset];
    }

    size_t GetModulusSize() const NN_NOEXCEPT
    {
        return ModulusSize;
    }

    const uint8_t* GetPublicExponent() const NN_NOEXCEPT
    {
        return &m_DeviceCertificate.data[DeviceCertificatePublicExponentOffset];
    }

    size_t GetPublicExponentSize() const NN_NOEXCEPT
    {
        return PublicExponentSize;
    }

private:
    const int DeviceCertificateModulusOffset = 0x108;
    const int DeviceCertificatePublicExponentOffset = 0x208;
    const size_t ModulusSize = 256;
    const size_t PublicExponentSize = 4;

    settings::factory::Rsa2048DeviceCertificate m_DeviceCertificate;
};

}} // namespace nn::es
