﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/err/err_ErrorResultVariant.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace err {

ErrorResultVariant::ErrorResultVariant() NN_NOEXCEPT
    : m_State(ErrorResultVariantState_HasNone)
{
}

ErrorResultVariant::ErrorResultVariant(const Result& result) NN_NOEXCEPT
    : m_State(ErrorResultVariantState_HasResult)
{
    m_Data.resultValue = result.GetInnerValueForDebug();
}

ErrorResultVariant::ErrorResultVariant(const ErrorCode& errorCode) NN_NOEXCEPT
    : m_State(ErrorResultVariantState_HasErrorCode)
{
    m_Data.errorCode = errorCode;
}

ErrorResultVariant& ErrorResultVariant::operator=(const Result& result) NN_NOEXCEPT
{
    m_State = ErrorResultVariantState_HasResult;
    m_Data.resultValue = result.GetInnerValueForDebug();
    return *this;
}

ErrorResultVariant& ErrorResultVariant::operator=(const ErrorCode& errorCode) NN_NOEXCEPT
{
    m_State = ErrorResultVariantState_HasErrorCode;
    m_Data.errorCode = errorCode;
    return *this;
}

ErrorResultVariant::operator Result() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(m_State, ErrorResultVariantState_HasResult);
    return result::detail::ConstructResult(m_Data.resultValue);
}

ErrorResultVariant::operator ErrorCode() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(m_State, ErrorResultVariantState_HasErrorCode);
    return m_Data.errorCode;
}

ErrorResultVariantState ErrorResultVariant::GetState() const NN_NOEXCEPT
{
    return m_State;
}

}}
