﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/err/err_SystemTypes.h>
#include <nn/fs/fs_ErrorReport.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>

#include "err_ErptUtil.h"

namespace nn { namespace err { namespace detail {

void SubmitFileSystemInfo() NN_NOEXCEPT
{
    nn::fs::SetErrorReportNsInfo();
    nn::fs::SetErrorReportFileSystemInfo();
}

void ClearFileSystemInfo() NN_NOEXCEPT
{
    nn::fs::ClearErrorReportNsInfo();
    nn::fs::ClearErrorReportFileSystemInfo();
}

void SubmitApplicationId(nn::ApplicationId applicationId) NN_NOEXCEPT
{
    erpt::Context context(erpt::CategoryId::ApplicationInfo);
    char applicationIdString[17];
    util::SNPrintf(applicationIdString, sizeof(applicationIdString), "%016llx", applicationId.value);
    NN_ABORT_UNLESS_RESULT_SUCCESS(context.Add(erpt::ApplicationID, applicationIdString, static_cast<uint32_t>(util::Strnlen(applicationIdString, static_cast<int>(sizeof(applicationIdString))))));
    NN_ABORT_UNLESS_RESULT_SUCCESS(context.SubmitContext());
}

void ClearApplicationId() NN_NOEXCEPT
{
    erpt::Context context(erpt::CategoryId::ApplicationInfo);
    NN_ABORT_UNLESS_RESULT_SUCCESS(context.SubmitContext());
}

void AddResultBacktrace(erpt::Context* pOutValue, const err::ResultBacktrace& resultBacktrace) NN_NOEXCEPT
{
    if( resultBacktrace.count == 0 )
    {
        return;
    }
    uint32_t resultArray[ResultBacktrace::CountMax];
    for( int i = 0; i < resultBacktrace.count; i++ )
    {
        resultArray[i] = resultBacktrace.results[i].GetInnerValueForDebug();
    }
    NN_ABORT_UNLESS_RESULT_SUCCESS(pOutValue->Add(erpt::FieldId::ResultBacktrace, resultArray, static_cast<uint32_t>(resultBacktrace.count)));
}

}}}
