﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs.h>
#include <nn/erpt/server/erpt_ServerTypes.h>

namespace nn   {
namespace erpt {
namespace srv  {

enum StreamMode
{
    StreamMode_Write,
    StreamMode_Read,
    StreamMode_Invalid
};

class Stream
{

private:
    static bool         m_FsAvailable;
    uint32_t            m_BufferSize;
    uint32_t            m_FilePosition;
    uint32_t            m_BufferPosition;
    uint32_t            m_BufferCount;
    uint8_t*            m_pBuffer;
    StreamMode          m_StreamMode;
    bool                m_Initialized;
    nn::fs::FileHandle  m_FileHandle;
    char                m_Name[ReportFileNameLength];

    nn::Result Flush()
    NN_NOEXCEPT;

public:
    nn::Result OpenStream(const char* path, StreamMode mode, uint32_t streamBufferSize)
    NN_NOEXCEPT;

    nn::Result ReadStream(uint32_t* pReadCount, uint8_t* pBuffer, uint32_t length)
    NN_NOEXCEPT;

    nn::Result WriteStream(const uint8_t* pBuffer, uint32_t length)
    NN_NOEXCEPT;

    static nn::Result DeleteStream(const char* pPath)
    NN_NOEXCEPT;

    static nn::Result CommitStream()
    NN_NOEXCEPT;

    static void EnableFsAccess(bool enable)
    NN_NOEXCEPT;

    void CloseStream()
    NN_NOEXCEPT;

    static nn::Result GetStreamSize(int64_t* pSize, const char* path)
    NN_NOEXCEPT;

    nn::Result GetStreamSize(int64_t* pSize)
    NN_NOEXCEPT;

    Stream()
    NN_NOEXCEPT;

    ~Stream()
    NN_NOEXCEPT;
};

}}}
